
- New: The repository manager has been redesigned
    - The outline is now searchable
    - Updating repository status is now faster
- New: The branch tracking menu gained a search bar for filtering branches
- New: The git toolchain is now universal (`arm64`/`x86`)
- New: Holding down `OPTION` when opening a repository via quick actions will open it in a new tab
- Window and tab titles use the custom display name of the repository instead of the repository folder name
- Disable SSH authentication option for HTTPS remotes
- The default `Quick Action` shortcut was changed to `CMD+P`
    - macOS 11 uses the previous default `CTRL+SPACE` to change input sources
- Authentication `None` was changed to `SSH Public Key`
- Raised deployment target to `10.14`
- The repository and stash icons have been updated
- Changed outline label colors to work better with custom accent colors
- Fixed an error when restoring AppStore purchases
- Fixed issue resulting in incorrect or missing user shell `PATH`s
- Fixed several layout alignment issues with labels
- Many other smaller UI changes

#### Build 4910 - Nov 19 2020 

- New: Support for macOS Big Sur
    - New application icon
    - Interface improvements to complement the new design language
    - Built for Apple Silicon (arm64)
- New: Support for directory diffs
- New: The pull and save stash panels use a new layout without collapsible sections
- New: The following panel options will now be stored in your user preferences 
    - Fetch All Remotes
    - Fetch All Tags
    - Push All Tags
    - Squash Commits
    - Track Branch
    - Pop Stash
    - Restore Index
    - Keep Staged Changes
    - Include Untracked
    - Include Ignored
- When staging a folder, the previously selected row index is now preserved 
- Fixed: Comment lines no longer show a line number in the gutter
- Fixed: Stash context menu no longer shows rebase options
- Fixed: Clipped commit info view when ref labels grew too large
- Fixed: Issue  where `git-flow` tried to open a prompt resulting in a hang on init

#### Build 4818 - Oct 21 2020 

- New: Split Diff View
    - The diff view now splits at a predefined width configurable under `View > Diff Collapse`
    - Diff whitespace can now be shown with `View > Show Whitespace`
    - Text is now always copied as plain text
    - The same colors are now used for light and dark mode
- New shortcuts for:
    - Show Whitespace
    - Show Commit Diffs Expanded
- The commit UI is now locked until all hooks have finished running
- Diff font size select was moved from preferences to `View > Diff & Commit Font Size`
- Fixed hang when launching Gitfox with large `/bin/env` output
- Fixed issue that loses the gutter selection when scrolling too far away
- Fixed issue that resulted in wrong diff cell height
- Fixed issue when parsing diffs with double leading `+` and `-`

#### Build 4642 - Sep 07 2020 

- New: Support dynamic font size in config editor
- New: Use syntax highlighting for config editor comments
- New: `Copy Message` log context menu action
- New: The stash list now shows parsed target reference and stash index labels
- New: 2 new font size classes, XX-Small and XX-Large
- The commit message text view now adjusts its height to match the current font size
- Show disclosure indicator on submodule outline cells
- Improved legibility of editor placeholder text enabling subpixel quantization
- More compact and crisp outline `HEAD` and upstream change labels
- New search, query, insertion, deletion and stash label colors
- The apply stash panel now truncates long stash messages to prevent a large panel width
- The drop stash panel now shows the stash and target refnames instead of the stash commit hash
- The bundle identifier for the retail version changed to `com.bytieful.Gitfox-retail` to distinguish it from the AppStore version
- Fixed: Default values for subject/body length and font size were not correctly preselected

#### Build 4584 - Aug 30 2020 

- New: Quick Actions where completely overhauled
    - Over 47 new actions
    - Improved fuzzy matching
    - Dynamic actions for file paths, repository URLs and remotes
    - New path completion popup
    - Clone directly by pasting a repostiroy URL
- New: `View > Show Graph` menu item
- New: The `PATH` from the default user shell is now inherited
    - You can see the default shell and `PATH` in the integration preferences tab
- New: Support for separate worktrees created with `git-worktree` 
- Submodule update tasks now shows the submodule name and progress 
- Toolbar buttons now respect the system tint and are animated
- Improved window push/pop animation duration and speed
- The `git-credential-osxkeychain` helper is now bundled
    - This caused issues when the helper was configured in the users `.gitconfig`
- Use `GIT_CONFIG_NOSYSTEM` to prevent global config access errors in the AppStore sandbox
- Disable the outline view vibrancy
    - Vibrancy prevented consistent label color contrast accross different window backgrounds
- Fixed: Submodules now show correct changes count instead of just `M` (modified)
- Fixed: Merge actions now always reports git output for merge conflicts and other errors
- Fixed: Crash caused by invalid selection in repository outline

#### Build 4460 - Aug 17 2020 

- Fixed: Inconsistency when displaying status rows, causing the checkmark to show a wrong state

#### Build 4451 - Aug 14 2020 

- Fixed: Error when trying to get status of uninitialized submodule

#### Build 4445 - Aug 13 2020 

- Fixed: Failure to access `/etc/gitconfig` in AppStore build

#### Build 4437 - Aug 06 2020 

- New: Submodules
- New: Support for bare repositories
- Rebase:
    - New menu items for all rebase actions
    - Actions can now be configured with hotkeys
    - Actions now also work for root commits
    - `core.trustctime` is now explicitly set to false when starting a rebase
- Directories and submodules now show a folder icon in the file status list
- Commit labels now show an ellipsis if some labels are hidden
- File status preserves selection for unstaged `RENAMED` file pairs
- The window title now shows the represented repository folder
- Improved UI performance
- Fixed: Don't force `git-flow` default initialization, causing it to override empty values 
- Fixed: Crash when reading a malformed `.gitconfig`
- Fixed: Crash when trying to move commit before first commit
- Fixed: Properly set the window title and represented URL
- Fixed: Missing stash and reflog bar icons

#### Build 4255 - Jul 10 2020 

- New: Graph
    - Shows all local branches, remote branches and tags
- New: Multiple Selection
    - Select and delete multiple branches at once in the outline
    - Select and delete entire folders
    - Remotes are now selectable and show all branches for that remote
- New: Window and toolbar appearance is now configurable
    - Choose `View > Show/Hide Window Title` to toggle title appearance
    - When a window title is shown, you can now opt to show toolbar labels
- New: Optional toolbar buttons for `Terminal`, `Finder` and `Editor` 
- New: Difftool integration for `Beyond Compare`
- `Kaleidoscope` integration can now be used without installing the `ksdiff` tool
- Status view now uses same font size as search bar and has a flatter appearance
- Fixed: Issue where the commit bullet had the wrong color

#### Build 4222 - Jul 02 2020 

- New: Interactive Rebase
    - Drag and drop commits in the log to reorder them
    - Perform the following commands via the log context menu:
        - Edit
        - Reword
        - Drop
        - Squash
        - Fixup
- New: Comments are highlighted in the commit message view
- New: Fast-Forward branches without checking them out using `Fast-Forward <branch>`
- New: Options in `Main Menu > View`
    - Automatically expand commit diffs with `Show Commit Diffs Expanded` 
    - Change the number of shown diff context lines with `Diff Context Lines > <n> Lines` 
- Conflicted file rows are now highlighted in red
- When creating a new branch, whitespace in branch names will be automatically sanitized to `-`
- Several UI performance improvements
- Operations modifying the index are now locked to prevent `index.lock` errors
- Generated gravatars now have a stable color across app launches
- Git-Flow: Hotfixes use `master` as base if no base was provided
- Fixed: Issue that caused the wrong Gravatar to be loaded for a commit

#### Build 4081 - Jun 17 2020 

- Log: Copy selected commit SHAs with <kbd>CMD+C</kbd> 
- Cherry-Pick: Support for cherry-picking multiple commits from log context menu
- Fixed: Prevent adding repository duplicate when path has trailing slash
- Fixed: Correctly add repository to list and push window when `gf` is invoked
- Fixed: Show `gitflow` messages, even if they don't indicate an error

#### Build 4069 - Jun 14 2020 

- The font size setting now also affects the commit message font size
- Generated gravatars now produce more sensible letters
- Fixed: Properly clear outline selection after deleting repositories 
- Fixed: Crash caused by unhandled `SIGPIPE`

#### Build 4054 - Jun 11 2020 

- New: Create Local Repository
    - Initialize with `.gitignore` template
    - Initialize with Markdown README
- New: Push now supports `--force-with-lease`
- New: Preview `UNTRACKED` or `MODIFIED` images without staging
- Improved window management. Gitfox will switch to the opened repository window or tab instead of creating a new window on the following actions:
    - Open via `gf` commandline tool
    - `Open`, `Open Recent`
    - `Clone Repository...`
    - `Create Local Repository...`
    - Quick Actions
- Fixed: Issue in the auth system that caused the application to hang when idle for a long time

#### Build 4012

- New: Diff File Context Menu
    - Copy Filename
    - Copy Relative Path
    - Copy Absolute Path
- New: Copy selected diff file path with <kbd>CMD+C</kbd>
- Repository links are now also accessible from the repository manager
- Fixed: High CPU usage when viewing certain diffs
- Fixed: Correctly handle diff output with `CRLF` at end of line
- Fixed: Back button is now disabled in repo manager
- Fixed: Issue where a leading number in the repository URL path caused malformed issue links

#### Build 3999

- New: Service Accounts
    - Support for `Github`, `Bitbucket` and  `Gitlab` accounts via OAuth.
    - Support for regular HTTP accounts via `Basic Authentication`. Please note that you may have to re-enter your credentials, since the new account system works completely different compared to the old one.
    - Preference pane for managing service accounts
    - A dialog will now appear on authentication errors, asking you to select the appropriate account.
    - New  `Remote > Authorization > Account` context menu for selecting service accounts
- Updated bundled `git` to `2.26.2`
- Updated `libgit2` to `1.0.0`
- Updated `cmark` to `0.29.0.gfm.0`
- Removed bundled `ssh` binary, using system binary instead
    - Resolves SSH `Unsupported Option` errors 
    - This also means that you won't be prompted for `SSH` private key passphrases anymore. Please configure those in your `ssh-agent`. 
- Fixed: Clone panel now shows full error message in alert panel, instead of just last line
- Fixed: Accessory view (change count) is now always drawn with high contrast colors when selected
- Fixed: Crashes caused by `ObjC` exceptions thrown from Apples frameworks
- Fixed: Pixel jumping on update in repository outline
- Fixed: Issue where log would not refresh after a forced push or fetch
- Fixed: Issue when "Use keyboard navigation to move focus between controls" was enabled
    - The selected files now correctly un/stage when the <kbd>SPACE</kbd> key is pressed
    - The status table no longer loses focus after staging files using the <kbd>SPACE</kbd> key

#### Build 3831

- Prevent center column from expanding for very long branch names
- Correctly truncate long branch names in the current branch view
- Show only the shortest branch name in the current branch view when a merge head points to multiple branches
- Fixed: Reliably clear the commit message after a merge

#### Build 3817

- Add `/usr/local/bin` to internal search `PATH`
    - Allows usage of external difftools located in `/usr/local/bin`
- Don't allow trashing of already deleted files
    - Play alert beep instead of showing git error message
- Fixed: Regression that caused the Commit button to be disabled, despite having a valid commit message
- Fixed: Crash when updating file status rows (moves)

#### Build 3800

- Fixed: Crash that was caused by pressing <kbd>CMD+Z</kbd> directly after commit

#### Build 3796

- Use bigger font size for multiple selection label
- Fixed: Correctly update diff button bar after un/staging parts
- Fixed: Renamed files now properly reset
- Fixed: Disable resetting of untracked files
    - You will hear an beep instead
- Fixed: Workaround for AppKit dangling pointer bug
    - Resulted in crash when collapsing the activity view when the app was not active.
- Fixed: Disable line selection for `ADDED` files
    - Lines cannot be unstaged for newly created files

#### Build 3780

- New: Editor Support
    - Select your favorite Editor under `Preferences > General`
    - Open editor for the current repository with <kbd>⌥⌘E</kbd>
- New: Diffs now display the number of changes next to the filename
- Diffs now use `git-diff` instead of libgit2
    - This resolves a long standing issue that resulted in corrupted memory and crashes for certain diff outputs
- The status list is now generated using `git-status` instead of libgit2
    - Resolves issues with path casing when committing on different operating systems
- Several text inputs, like the clone URL field, now properly wrap text
- `Diff View > File > Restore <FILE>` now properly restores deleted files
- Disabled spellchecking for diff outputs to improve performance
- Fall back to default SSH identity if specified key file cannot be found
- Improved `No matching identity found.` error message to tell you what SSH host is misconfigured
- Improved diagnostics and error reporting
- Fixed `Operation timed out` error

#### Build 3542

- New: Customizable Shortcuts
    - New preference pane for customizing every shortcut
- New: Shortcuts
    - Delete <kbd>⌘⌫</kbd>
    - Reset Selected Files <kbd>⇧⌘⌫</kbd>
    - Discard All Changes <kbd>⌥⇧⌘⌫</kbd>
- New: Change diff font size
- New: Drag & drop support for files in status list
- New: Identities now show the full signature, including email
- The branch status labels now use a larger, more compact font
- Fixed opening repositories via the `gf` CLI tool on Setapp
- Fixed disappearing glyphs when highlighting multi-byte characters
- Fixed blurry Gravatars on retina displays

#### Build 3480

- Fixes a layout issue that results in a crash on macOS 10.14 and older

#### Build 3474

- New: Issue links are now highlighted for the following hosting services
    - Github
    - Gitlab
    - Bitbucket
- New: The source code font has been changed to `SF Mono`
- New: The `Status` and `File Name` columns are now sortable
- New: Drag & Drop actions
    - Create tag from branch by dragging to `Tags` group
    - Merge, rebase and cherry-pick by dragging to `HEAD` or `Working Copy`
    - Pull remote branch by dragging to `HEAD` or `Working Copy`
    - Track remote branch by dragging to `Local` group
- The committer is no longer hidden in the commit info view if it is the same as the author for better consistency
- Fixed an issue that resulted in a git error when staging an already staged `DELETED` file

#### Build 3446

- New: Set preferred Terminal application
    - Select your preferred Terminal in `Preferences → General`
- New: Set preferred Diff- and Mergetool
    - Select your preferred tools via `Preferences → Integration`
- New: Log context menu `Copy <n> SHAs`
- Improved Inline-Diff
    - Word boundaries are now taken into account to produce better looking diffs
- The `Stage` and `Unstage` view selection now remembers the last user selection
- Apply- and Save Stash icons have been update
- The `Branch` and `Stage` menus were partially merged into the `Working Copy` menu 

#### Build 3396

- New: Background Fetch
    - You can now configure a background fetch interval in the new preferences dialog
- New: Notifications
    - Notifications are now shown if new commits where pushed, pulled or fetched
- New: Preferences have been migrated to the preferences dialog
    - General: Commit line width settings
    - General: Automatic background fetch interval
    - Integration: Command-Line tool install
    - Update: Channel and interval
- New: The commit area now collapses to a more compact view when it is not first responder
- New: The outline is now searchable via the search bar below
- New: Generate unique gravatars if no user image found
- New: The HEAD branch can now be collapsed in the "Working Copy" view
- New: The activity pane automatically shows and collapses
- New: Outline context menu items for branch push and pull
    - Branch: `Push To...`
    - Branch: `Pull...`
- Don't display an error if a merge conflict occurs on finishing a git-flow task

#### Build 3309

- Clone: You will now be prompted if you want to overwrite a directory on clone if it already exists
- Clone: Now also succeeds even when the checkout after clone might fail
- The `mdown` extension is now also recognized for markdown READMEs
- Fixed an error with the `git-submodule` command on clone

#### Build 3298

- New: Touch Bar Support
    - Repository View: `Fetch`, `Push`, `Pull`, `Merge`, `Rebase`, `Stash`
    - Commit Text Field: `Sign Off`, `Amend`, `Commit`, `Commit & Push`
    - Repository Manager: `New Tab`, `Open`, `Clone`
- New: All branches now show how many commits they are ahead or behind tracking
    - The accessory view font size has been reduced to accomodate the additional information
- Hardened Runtime has been enabled for embedded binaries
- Always draw graph in topological order

#### Build 3236

- New: Tabbed window support has been added
- New: Outline Context Menu
    - `Branch → Rename`
    - `Branch → Copy`
- Show branch select panel when pushing or pulling `HEAD` and no remote tracking branch is set 
- Show `No Tracking` if the current branch has no tracking branch set
- Fixed an issue displaying the resolve interface when a stash apply resulted in a conflict
- App Store: Emergency fix for `git` process receiving `SIGKILL`

#### Build 3207

This update contains a lot of changes, only the most important are listed here:

- New: The Git core has been entirely rewritten to improve the overall experience
    - Efficiently uses all available CPU cores
    - Increased reliability through better third-party code isolation
    - Reduced memory consumption
    - Using native embedded `git` and `ssh`
- New: Working Copy
    - Your HEAD and changes are now shown in the `Working Copy` outline section
- New: Git Flow
    - Git Flow has been integrated and is available via the toolbar
- New: Support for multi-line inline diffs
    - Multiple adjancent additions/deletions are now diffed against each other
- Links have moved to the toolbar
    - Open in Terminal/Finder and Links are now accessible via the same button
- Support for Git hooks and elliptic curve SSH keys
- Search: The search bar was moved to the toolbar
    - Combine multiple search predicates using the <kbd>SHIFT</kbd> key
- The Diff view has been completely reworked to adjust dynamically to its width
- All input panels have been completely reworked
    - Most commands now have many more options
- Remote URLs and names can now be edited
- Comment lines (`#`) are now automatically stripped from merge messages
- Gravatars are now cached on disk and loaded in parallel
- Any configuration file in the `Settings` section can be saved using `⌘S`
- The `gf` commandline tool has been updated to support custom paths. Type `gf --help` for more.
- And many more...

#### Build 2470

- New application icon to better align with macOS iconography
- Update third party dependencies to latest versions
- Inprove accessory view colors, font and spacing
- The `README` link has been removed from the repository outline in favor of the repository manager
- Updated the default toolbar layout
- Updated the main menu for a more native layout
    - Some menu items have been moved from the `Repository` to the `File` menu
- The updater now checks more frequently, even if you are not quitting the app
- Fixed the refresh menu shortcut
- Fixed the status view progress spinner kept spinning when popping views
- Fixed a crash that was caused by uncaught `NSException`s when reading from the git process

#### Build 2422

- New repository manager
    - You can now manage your repositories with the new repo manager outline
    - The whole window has been reworked and some outline and branch buttons moved to the new toolbar
- Updated for macOS Catalina
- The commit message view now highlights leading whitespace in empty lines
- The commit message view now uses the default system monospace font
- Section plus buttons have been removed and the actions moved to new main and context menu items
    - `Repository → Manage Links`
    - `Repository → Add New Remote`
    - `Links Group → Context Menu → Manage Links`
    - `Remote Group → Context Menu → Add New Remote`
- The README markdown style now adjusts for dark mode
- New `Stage → Rebase HEAD` menu item
- New `Stage → Apply Stash...` menu item
- New `Apply Stash` panel
- Moved `Branch → Merge Into Head` menu item to `Stage → Merge Into Head`
- Renamed `Stage → Stash Changes` menu item to `Stage → Save Stash...` 
- Fixed an issue where remotes in the outline are not updated on add or delete
- Fixed an issue where <kbd>⌃Click</kbd> would not work in the repository outline view
- Suggested cloned repo name is now always updated on URL change
- The window menu now reflects the correct window name depending on the currently opened repository
- Fixed blurry avatars and missing rounded corners
- New windows now properly cascade
- Major performance increase when staging/unstaging files
- Quick actions are now ordered before recent repositories in the quick action window

#### Build 2312

- New: Support for encrypted SSH keys
    - You will now be prompted for a passphrase if your private key is encrypted
    - Auth system was completely overhauled
- Fixed a crash when trying to open a `bare` repository
- An alert is now shown when trying to open a `bare` repository

#### Build 2295

- New: Conflict Resolution
    - Select which side of a conflict you want to resolve to using the new conflict UI
    - New status context menu items:
        -  `Status → Context Menu → Resolve Conflict using Ours`
        -  `Status → Context Menu → Resolve Conflict using Theirs`
- New:  `Status → Context Menu → Discard All Changes` resets all changes to `HEAD` (hard)
- New menu item `Stage → Amend ⇧⌘A`
- The `Amend` checkbox is now always visible
- Github repositories now automatically create a link for `Milestones`
- Gits prepared message from `.git/MERGE_MSG` is now used for `revert`, `cherry-pick` and `merge`
- Aborting a `revert` or `cherry-pick` now clears all staged changes and the commit message
- Symbolic remote branches like `HEAD` are no longer shown in the remote branch outline
- The file status table has been redesigned
- The file icon is now displayed next to the filename
- The selection info text `n commits/files selected` now changes based on the selected content type
- The selected commit is no longer cleared when beyond the first page of commits
- The application now checks for the `com.apple.quarantine` flag on startup
- Fixed an issue that prevented branch creation when `Check Out` was not selected
- Fixed an issue that would not update the status list if an active search was in progress

#### Build 2224

- The default shell is now inferred from the default handler for files of content type
    - `public.unix-executable`
- Menus:
    - `Index` has been renamed to `Stage`
    - `Index → Stash` has been renamed to `Stage → Stash Changes` 
    - `View → Show HEAD Branch` has been renamed to `View → Show HEAD` and moved to top
- When creating a new branch, `Track "branch"` is now automatically checked for remote and unchecked for local branches
- Merges with no conflicts are now automatically committed. Previously it would behave like `git merge --no-commit`
- Diff and line-selection performance has been greatly improved for very large diffs
- `No file selected` is now shown in the diff pane if nothing is selected
- Status list now properly updates on reset
- Prevent diff view from jumping to top on reload
- Aborting a Rebase now properly clears the commit message field

#### Build 2103

- Fixed issue that caused license not to load on app startup
- New `Help → Follow @gitfoxapp` menu item

#### Build 2099

- New: Reflog is now available in the sidebar
- New: Stashes have been moved to the sidebar
- New: Drag and Drop has been overhauled
    - Drag remote branch on `LOCAL` group to checkout / create new branch
    - Drag commits on `HEAD` to cherry-pick
    - Drag reflog entries on `HEAD` to cherry-pick
    - Drag stash entries on `HEAD` to apply
    - Drag commits to `TAGS` group to create new tags
- New: Menu Shortcuts
    - `Branch → Fetch ⇧⌘F`
    - `Branch → Fetch All Remotes`
    - `Branch → Pull... ⇧⌘P`
    - `Branch → Pull HEAD ⌥⇧⌘P`
    - `Branch → Push... ⇧⌘U`
    - `Branch → Push HEAD ⌥⇧⌘U`
    - `Branch → Create New Branch ⌘B`
    - `Branch → Create New Tag ⇧⌘T`
    - `Index → Toggle Stage All ⇧⌘Space`
    - `View → Show README ⌘1`
    - `View → Show Settings ⌘2`
    - `View → Show Stashes ⌘3`
    - `View → Show Reflog ⌘4`
    - `View → Show HEAD Branch ⌘0` 
- Stash Panel: `Keep Index` has been renamed to `Keep Staged Changes`
- When creating a new branch from a remote branch, the local name is now automatically suggested
- Rebase now shows a confirmation dialog before rebasing
- The HEAD branch now shows a `•` indicator if it has changes
- Push pull count is now updated after amending commit
- The first log entry is now automatically selected on branch switch
- The `ref` labels are now correctly updated on pull
- The staged/unstaged selection now changes back to "unstaged" when slecting a different status
- Fixed repository outline jumping to top when changing selection
- Fixed a crash when updating the satus list
- Fixed an issue in `libssh2` that caused problems with some public key formats
- Fixed an issue in `libgit2` that caused an error with certain ignore patterns
- Fixed an issue that prevented a status update when the window became key
- More memory optimization

#### Build 1993

- Update reference labels on rebase and merge
- Fixed an issue that caused Gitfox to quit on `SIGPIPE` if the SSH public key was malformed
- Authentication errors now show more info about the chosen authentication method
- OpenSSL and LibSSH2 were updated to the latest version

#### Build 1966

- Gravatars now use less memory
- CLI tool is now copied to /usr/local/bin to avoid problems with Gatekeeper Path Randomization
- Fixed an issue that caused an error alert loop on certain repository errors
- Fixed an automation entitlement issue that made the app quit on some systems

#### Build 1949

- Improved memory consumption across the board

#### Build 1935

- Fixed: Show correct tag name in tag outline context menu

#### Build 1931

- Fixed: Selected tag in outline now keeps selection
- Fixed: Crash when updating file status
- Fixed: Empty quick action window on open

#### Build 1912

- New: Line Staging
    - Individual line un/staging is now possible via the context menu or top toolbar
    - You can now display separate diffs for the staged and unstaged content
- New: Menu Items
    - `Repo → Refresh ⌘R`
- Fixed: Performance issue with line highlighting in big files
- Fixed: The correct author and committer are now selected when Cherry-Picking
- Fixed: Show correct folder name in context menu when trashing folder 

#### Build 1894

- The Quick Action and Repo windows are now animated
- Fixed an ObjC exception in the diff view that caused a crash in certain cases
- Release notes no longer show on first launch
- The initial window size has been increased
- License and Hello window are no longer floating

#### Build 1881

🎉 Gitfox is now officially released 

A big thank you to all our early testers!

#### Build 1871

- Diff pane now automatically selects new commit after committing
- Push and pull count is now properly updated when branch tracking changes
- The correct upstream remote is now preselected in the fetch panel
- The correct upstream branch is now preselected in the pull panel
- Fixed: error alert loop when the selected branch did not exist
- Fixed: changes in diffs for renamed files are now shown properly
- Fixed: issue with max log column width
- Fixed: commit targets of tag references were not resolved properly

#### Build 1842

- Updated application icon
- Lighter commit message length highlight colors
- Fixed issue when trying to commit reverted commits

#### Build 1834

- Status list is now sorted by filename instead of path for better grouping
- Fixed an issue that would result in an error loop if the upstream branch no longer exists
- Made log author label color less prominent

#### Build 1825

- New: Branch Compare `Branch → Context Menu → Compare to HEAD`
- New: Commit Diff
    - Select single commit `Commit → Context Menu → Open Difftool`
- New: Commit Range Diff
    - Select multiple commits to show the difference between the oldes and newest  `Commit → Context Menu → Compate "<old>" to "<new>"`
- Selection display was moved to the toolbar
- Added `Difftool` toolbar button
- Most icons have been redesigned for consistency
- The first commit is now automatically selected upon opening a repo

#### Build 1818

- New: You can now add and manage multiple identities
- New: Author and Committer can be selected on a repository basis
- New: Author and Committer signatures can be amended
- Remotes are now pruned on fetch
- Fixed a segfault in `libgit2`, reduced cache size back to 25MB.
- Fixed issue where log row would not fill entire width
- Fixed an issue where the commit button would be disabled on `merge` if there are no files to commit
- Fixed an issue where the UI would not update when there was a conflict while `pull`

#### Build 1805

- **New**: Commit Revert
    - `Commit → Context Menu → Revert Commit`
- **New**: Commit Cherry-Picking
    - `Commit → Context Menu → Cherry-Pick Commit`

#### Build 1781

- **New**: Branch Graph
    - The log now shows you the branch graph
- Branch tracking name is now correctly updated when set on push
- Tag labels and refs now update instantly on change in the log or commit info view
- Reduce git object cache size to reduce memory footprint
- Fixed a regression in "Quick Pull"

#### Build 1756

- Reworked Activity UI
    - Improved progress text for fetch, push and pull 
    - Improved activity UI performance
- Simplified clone window

#### Build 1740

- New: Application Icon
- New: `gf` command-line utility to open repositories
    - Install via `Gitfox → Install CLI Utility`
- New: Diff and Mergetool Support
    - `Index → Open Diff or Mergetool` to open tool with selected files
    - `Selected Files → Context Menu → Open Diff or Mergetool`
    - Valid `(diff|merge).tool` presets are:
        - `opendiff`
        - `araxis`
        - or any `(diff|merge).tool` that has a configured `(diff|merge)tool.<tool>.cmd`
      
#### Build 1728

- Your commit message now is saved if you quit the app and restored on launch
- SSH aliases are now resolved correctly
    - Values from your `.ssh/config` for `HostName`, `User` and `Port` are now used for resolving SSH aliases before connecting 
- Fixed an issue with setting the commit message during a rebase with multiple conflicts

#### Build 1718

- Merge and Rebase has been completely reworked
    - Drag a branch on top of HEAD and press <kbd>⌥</kbd> to rebase
    - New rebase and merge control UI
    - New branch context menu items
        - `Merge <branch> into HEAD`
        - `Rebase HEAD on <branch>`
- Quick action path completion has been greatly improved
    - Shows all possible completions for directories
    - Completion is case insensitive
- Simple amend has been restricted to `HEAD` again, since this will be moved to interactive rebase

#### Build 1701

- New: You can now amend commit messages on any commit, not just tip
- New: The commit area and text field can now be resized by dragging the divider below
- Hidden outline groups are now saved and restored upon launch
- In addition to <kbd>click</kbd> or <kbd>⌥ - click</kbd> on the repository title, there are now 2 explicit link items for
    - `Open in Finder`
    - `Open in Terminal`
- Moved `Links` to own outline section
- Link management has been moved from settings to a dedicated panel accessible via the `+` button

#### Build 1665

- New `Commit → Checkout <ID>` context menu
- New `Status → Stage/Unstage Files` context menu
- The commit message view now highlights characters exceeding the `50/72` char limit
- Outline selection now always highlights the currently viewed `ref` 
- Files are now staged asynchronous
- Fixed an issue with the selection label not being correctly centered

#### Build 1611

- New: Search matches are now highlighted in the log, commit and diff 

#### Build 1580

- Fixed an issue where autoupdater would not check for updates

#### Build 1577

- New: `Diff → File → Context Menu → Restore File`
- New: `Commit → Context Menu → Create Branch from Revision`
- New: A confirmation dialog is now displayed before resetting or trashing files
- New: Automatically add `Milestones` link for gitlab remotes
- `File → Context Menu → Reset All Files` is now always visible
- Toggle all button is now disabled if there are no files
- Fixed: HTTPS auth can now be cancelled
- Fixed: Modifier button title no longer disappears on click

#### Build 1547

- Merge commits now show diffs
- Diff view now handles very large diffs better (asynchronously)
- UI performance improved in many cases
- Fixed: diff line selection could be laggy for large new files
- Fixed: loading large commit diffs should now be quicker
- Fixed: small images are no longer clipped

#### Build 1513

- New: Content of untracked files is now shown in the diff view
- Diffs of renames are now shown with their old paths
- Improved diff binary detection 

#### Build 1500

- New: Groups in the outline view are now collapsable
- New: Line discard is now enabled for fully staged files (not partial)
- New: The current line is now always highlighted on hover in the gutter
- New: You can now choose the destination directory name when cloning a repository
- Links are now stored in repository specific user defaults rather than `.git/config` 
- Links are now only auto-populated the first time the repository is opened
- Fixed: Quick Push now uses the correct tracking branch

#### Build 1477

- New: Diff view now supports hunk and line discarding
- New: Image diff now shows file sizes
- All commits now display files collapsed
- Fixed: clipped image diff label
- Fixed: preserve aspect ratio of images in diff
- Fixed: <kbd>⌥ click</kbd> on diff file disclosure arrow toggles all files again
- Fixed: diff no longer scrolls clicked diff file header to top
- Fixed: the status and log split view now properly saves its splitter position
- Fixed: commit button now shows as enabled after squash merge
- Fixed: push/pull count properly updates on commit

#### Build 1442

- Fixed resetting of `n` files

#### Build 1440

- New: File status context menu items
    - `Open`
    - `Open With`
    - `Reveal in Finder`
    - `Open in Terminal`
    - `Untrack`
    - `Ignore`
    - `Exclude`

#### Build 1417

- New: Button in `Settings → Links → Automatic` to automatically repopulate repository links
- Fixed case where log would not refresh on startup

#### Build 1411

- Improved startup time
- Support for authenticated HTTPS repository URLs
- You can now also link files (e.g. projects) in the "Repository" section
    - Autolink will now automatically populate your links with the first `xcworkspace` or `xcodeproj` found in your top level directory
- Branches and tags are now always in alphanumerical order
- Allow only one instance of a repository window
- Windows for repos that were removed on disk no longer persist

#### Build 1388

- Commit info now shows gravatar on right
- Commit info now shows committer gravatar below author
- Commit info now shows diff stats
- Fixed jumping scroll view indicator when navigation with keyboard
- Fixed commit info text selection

#### Build 1379

- Diff view can now be navigated with keyboard arrow keys
- Diff view now has an expand / collapse all button
- Hide Quick Action group headers if no elements are in the group
- Quick Actions "Actions" section now is on top
- Shorter repository names now come first in Quick Actions recently opened list
- Deployment target changed to 10.13.4

#### Build 1370

- Deployment target is now 10.13

#### Build 1368

- Activity view has a new vertical layout
- Suggest default message when saving stash
- Status list does no longer recurse untracked directories
- Fixed an issue where pull would not correctly fetch remote branches
- Fixed an issue where fetch locks up UI
- Fixed fetch cancellation

#### Build 1349

- Clone is now resolving deltas faster
- Clone now properly aborts when window closes
- Clone now properly shows delta indexing
- Fixed some race conditions
- Fixed inline diff for overlapping char ranges

#### Build 1317

- New menu shortcuts
    - Repo → Show in Finder <kbd>⌥⌘F</kbd>
    - Repo → Open in Terminal <kbd>⌥⌘T</kbd>
- Ref labels are now shown in the commit info view
- Committer is now hidden in the commit info view if it is the same as author
- Now shows as many ref labels as possible on the commit
- Quick action menu does no longer autohide
- Shortened commit date format
- Diff view scroller is now an overlay
- Diff view scroller no longer overlaps window resize areas
- Display release notes on update
