
- New: `Git` preference pane
    - Choose any `git` instance in your `PATH`
    - Update your global `git` user name and email
- New: Updated `git` to `2.35.1`
- Clear file selection on discard
- Include repository link in automatic links
- The 3-finger swipe between views is now dependent on the `Swipe between pages` system setting
    - This was done to prevent a conflict with the 3-finger drag accessibility option
- Fixed auto-populate of repository links
- Fixed repo names that contain periods
- Fixed label flicker in log when scrolling

#### Version 2.4.0 (6656) - Feb 04 2022 

- New: Compare any local, remote or tag ref to any other
    - New "Compare X To" context menu on reference items in the outline
- New: Sort local, remote and tag refs
    - New context menu on local, remote and tag sections
    - Sort methods:
        - Alphabetically
        - By Version
        - By Creator Date (Last Committed)
    - Sort options:
        - Reverse Order
        - Keep Folders on Top
        - Keep Default Branch on Top
- New: Option to copy refnames/shorthands from reference outline items
- New: "Push X" context menu item for individual tags
- Pre-fill branch name in copy/move dialogs
- Clear repo manager outline selection after delete
- Don't show repo delete alert for already deleted repositories
- Fixed tag delete if no remote present

#### Version 2.3.4 (6632) - Jan 20 2022 

- Fixed an issue that caused the changes view to immediately pop again

#### Version 2.3.3 (6629) - Jan 20 2022 

- Both, the commit and author date, are now shown in the `Date` row
- Minimum window width was reduced to 980px for better vertical display support
- Shortcuts are now shown in button tooltips
- Fixed: Properly update the log after a stash was pushed or popped
- Fixed: Crash when closing search predicate editor

#### Version 2.3.1 (6619) - Jan 11 2022 

- Fixed: Issue where autofetch would not work correctly

#### Version 2.3.0 (6617) - Jan 06 2022 

- New: Format and export mailbox patches for selected commits
- New: Apply mailbox patches with `Repository > Apply Patch...`
- New: `Meld` diff and mergetool preset
- Fixed: Error when trying to perform a directory diff
- Fixed: CSS dark mode image background color
- Fixed: Crash when trying to undo actions recorded in a different view
- Fixed: Crash when updating progress display
- Fixed: Crash when showing status popover and navigating views at the same time

#### Version 2.2.1 (6607) - Jan 03 2022 

- Fixed: Crash from exception caused by subprocess interrupt

#### Version 2.2.0 (6602) - Jan 02 2022 

- New: `Visual Studio Code` diff and mergetool preset 
- New: You can now filter the shortcuts list
- New: You can now drag and drop files from the status list to other apps or the dock
- New: The `Open With...` file context menu now also works if multiple files are selected
- New: Force push shortcuts and quick actions
    - Force Push with Lease... `OPT+CMD+U`
    - Force Push...  `CTRL+OPT+CMD+U`
- The shortcut system has been enhanced to support nested menu items
    - ⚠️ Due to the fundamental changes in the shortcut system you will have to rebind any custom shortcuts.
- The "Open/Show In" shortcuts have been split into explicit actions for your current selection or the whole repository:
    - Show Repository in Terminal `SHIFT+CMD+T`
    - Show Selection in Terminal `OPT+SHIFT+CMD+T`
    - Show Repository in Finder `SHIFT+CMD+F`
    - Show Selection in Finder `OPT+SHIFT+CMD+F`
    - Open Repository in Editor `SHIFT+CMD+E`
    - Open Selection in Editor `OPT+SHIFT+CMD+E`
- Many shortcut have been changed to shorter key combinations
    - Fetch: `CMD+SHIFT+F` to `F`
    - Fetch All Remotes: `None` to `OPT+F`
    - Pull: `CMD+SHIFT+P` to `P`
    - Pull HEAD: `CMD+SHIFT+OPT+P` to `OPT+P`
    - Push: `CMD+SHIFT+U`to `U`
    - Push HEAD: `CMD+SHIFT+OPT+U` to `OPT+U`
    - Create New Branch: `CMD+B` to `B`
    - Create New Tag: `CMD+SHIFT+T` to `T`
    - Open Diff or Mergetool: `CMD+D` to `D`
    - Toggle Stage All: `CMD+Shift+Space` to `OPT+Space`
    - Push Stash: `CMD+SHIFT+S` to `S`
    - Apply Stash: `CMD+OPT+SHIFT+S` to `OPT+S`
    - Rebase: `CMD+SHIFT+R` to `R`
    - Merge into HEAD: `CMD+SHIFT+M` to `M`
- The shell environment is now only evaluated once on startup to speed things up
- The error dialog now shows the combined output from STDOUT and STDERR
- Fixed: The "Show" button in the repository manager now correctly shows the repository again
- Fixed: Crash when external process produced a `SIGPIPE`
- Fixed: Race condition when loading large diffs
- Fixed: Overlapping text blocks in split diff view when certain unicode characters where used
- Fixed: Plural/singular in commit changes footer

#### Version 2.1.0 (6488) - Nov 20 2021 

- New: Commit Message Links
    - The link manager now has a new `Commit Message Links` section where you can specify custom regular expressions that are transformed into clickable links, e.g. for issue labels of external issue trackers.
    - HTTP URLs and issue references for services like GitHub, GitLab and Bitbucket are made clickable by default.
- The link manager shortcut was changed to `L`
- Text selection for commit header values is back
- The committer gravatar now only shows when the committer differs from the author
- Fixed an issue with truncated commit message text (ellipsis)
- Fixed an issue with clipped commit header labels
- Fixed empty `Parents` row for root commits
- Fixed empty log if git is misconfigured with an empty email address
- Fixed crash in conflicting shortcut popover
- Fixed GitHub and GitLab label casing

#### Version 2.0.7 (6455) - Nov 10 2021 

- Fix missing log entries if git author was misconfigured

#### Version 2.0.6 (6451) - Nov 08 2021 

- Fix stash push with empty message

#### Version 2.0.5 (6448) - Nov 07 2021 

- Fix crash when opening remote edit panel from "authentication failed" alert

#### Version 2.0.4 (6444) - Nov 06 2021 

- Ensure push stash `--all` and `--include-untracked` are mutually exclusive
- Fix memory leak in search predicate editor and file outline
- Fix crash that could occur when showing dialog panels

#### Version 2.0.3 (6431) - Nov 01 2021 

- Delete selected tags and branches using `CMD+DEL`
- Installing the CLI tool now asks for authorization to prevent permission errors
- Explicitly set `--no-track` option when creating a new branch from another to avoid implicit `branch.autoSetupMerge` behavior
- Restored branch name sanitizing replacing whitespace with `-` for branch and tag name inputs
- Fixed: Crash when displaying error panel while changing views

#### Build 6415 - Oct 26 2021 

- Correctly update the log when finishing git-flow branches
- More gravatar fallback colors
- Fix no files being displayed in merge commits
- Fix performance hiccup when switching between tree/changeset

#### Build 6401 - Oct 20 2021 

- Fixed: Crash in apply stash panel

#### Build 6397 - Oct 19 2021 

Welcome to Gitfox 2.0! 🎉

- The app has undergone a major rewrite and redesign to better fit macOS 11
- Commit and amend from anywhere with the new commit editor panel
- New text diff view
- New image diff view with split option
- File tree is now available
- Blame is now available
- New search predicate editor
- New grouped file view
- You can now compare any 2 commits
- The UI is now completely navigable by keyboard
- Diff font is now customizable
- Updated git to v2.33.0
- Any much more...
