- New: Merge preflight check
    - Shows the number of conflicts in the merge panel before performing the merge
- New: Add new merge panel options
    - `No Automatic Commit`
    - `Skip Hooks`
- Fix issue reading diff containing binary data fragments
- Fix issue with window title not showing custom display name

#### Version 3.2.1 (7764) - Dec 11 2022

- New: `Only Stash Staged Changes` option when pushing a stash
    - This is equal to `git stash push --staged` 
- Color hashes for avatars now produce more pleasing and consistent colors
- Fix repositories in folders not showing up as "Open" quick actions

#### Version 3.2.0 (7742) - Dec 2 2022

- New: Add and manage linked worktrees
    - New `Repository > Add Worktree... (W)` action
    - New `Remove` and `Open` linked worktree context menu items
    - Linked worktrees are now shown as children of the main worktree
    - Navigate to the linked worktree by double-clicking it in the outline
- New: Choose how to open linked worktrees and submodules
    - New `View > Submodules & Worktrees >` menu item
        - Option `Push in Same Window`
        - Option `Open in New Tab`
        - Option `Open in New Window`

#### Version 3.1.0 (7671) - Nov 22 2022

- New: The commit header view now has a compact format
    - You can toggle this via `View > Compact Commit Header`
- New: Commit header values can be copied in different formats
    - Identities: Email, name and mailbox
    - Dates: Unix and ISO 8601 timestamps
    - Hashes: The full hash
- Fix log update on stash save & apply
- Fix an issue preventing opening of repositories created with `git-worktree`
- Fix misaligned commit message text and label

#### Version 3.0.6 (7635) - Nov 14 2022

- The repository outline view now reacts properly to the "Sidebar icon size" system setting
- Use correct unstage symbol for "Unstage All" button 
- Replace all remaining icons with SF symbols throughout the app
- Fix issue where "Commit & Push" would not push afterwards
- Fix misaligned blame disclosure triangle
- Fix misaligned repository outline view disclosure indicators

#### Version 3.0.5 (7583) - Nov 9 2022

- Refresh service account after creating new repository on it
- Fix text views not properly scrolling while typing on macOS Ventura
- Fix micro hang when sorting refnames
- Fix deadlock when refreshing service accounts

#### Version 3.0.4 (7526) - Nov 2 2022

- Fix long refresh time in repository manager
    - Sometimes the repository status would not update for a few seconds
- Fix small delay at startup loading shell path

#### Version 3.0.3 (7516) - Nov 1 2022

- Keyboard navigation in the repository manager is back
- Accounts are loaded in the background to reduce app launch time
- Fixed some connection errors for GitHub accounts

#### Version 3.0.2 (7497) - Oct 31 2022

- Improved speed when restoring repository windows
- Disable context menu in README views
- Fixed connection errors for certain GitHub accounts

#### Version 3.0.0 (7473) - Oct 27 2022

Welcome to Gitfox 3.0 🎉

- New: Brand-new repository manager layout
- New: Code and commit statistics
- New: Remote service account repositories are directly shown in the repository manager
- New: Clone remote repositories with a single click
- New: When creating a new local repository, you can now choose to create it on a service account as well
- New: Show the README file for remote service account repositories
- New: Filter all repositories, including remote repositories
- Raised macOS deployment target to 12.4

#### Version 2.8.5 (7239) - Sep 26 2022

- Raised deployment target to macOS 12.3 
- Fixed an alert bar appearance bug when switching between light/dark mode
- Fixed an issue where the WORKTREE section did not show its upstream branch

#### Version 2.8.4 (7123) - Aug 24 2022

- Fixed GitLab authentication
    - GitLab removed support for non-expiring access tokens breaking repository authentication

#### Version 2.8.3 (7101) - Aug 17 2022

- Fixed an issue where the log would be empty if a folder in the repository had the same name as a branch
- Fixed an issue with stashes displaying the wrong fileset

#### Version 2.8.2 (7059) - Aug 5 2022

- Update `git` to `2.37.1`
- Update `cmark-gfm` to `0.29.0.gfm.4`
- Fixed lag when typing custom branch name in push dialog
- Fixed app closing on `SIGPIPE` when opening large README files

#### Version 2.8.1 (7023) - Jul 5 2022

- **New**: Store private key passphrases in your keychain
- License window now shows more info as well as last eligible version for OTP licenses
- Fixed frozen progress display when performing remote operations

#### Version 2.8.0 (6944) - May 25 2022

- **New**: Window and tab restoration
    - When enabled on macOS, previously opened windows and tabs are restored on app launch.
- Alert the user before adding a GitHub account on how to enable organization access for 3rd party clients.
- Fixed error display when submodule is misconfigured

#### Version 2.7.1 (6926) - May 17 2022 

- **New**: Allow dragging repositories from the repository manager to other apps in the dock
- Push dialog now automatically enters edit mode when selected local branch has no tracking
- Toggling multiple file statuses using `SPACE` is now based on the state of the first file
    - Previously all selected files would be either staged or unstaged based on their own status. This was changed so that now the status of the first file determines if the other files are staged or unstaged.
- Fixed Kaleidoscope integration (AppStore version)
    - Gitfox now uses the system `ksdiff` install instead of the bundled binary in the app bundle

#### Version 2.7.0 (6917) - May 14 2022 

- **New**: Create `Pull Requests` on supported services
    - The `Push` dialog has gained a new `Create Pull Request` option
    - Pull requests can also be created via the branch context menu
- **New**: Stashes now show untracked files
- Open difftool for selected files only
    - In case no files are selected, all files of the currently selected item are opened
- Long lived operations (e.g. push) are no longer cancelled when leaving a repository
- Allow opening of application bundles as repositories
- The custom upstream name is now always preset to the local branch name in the push dialog
- Fixed issue causing no stash message when pushing new stash

#### Version 2.6.2 (6894) - Apr 23 2022 

- **New**: All merged branches for your current `HEAD` are shown with a checkmark
- **New**: Change current branch, tracking and commit ordering from branch bar
- Show progress during branch switch/checkout
- Text spelling and substitution settings are now remembered (smart quotes etc.)
- The `Edit` menu has gained text edit commands
- Enforce a limit for concurrently running operations per repository
- Immediately check for update after changing update channel
- Improve performance with multiple tabs
- Fixed disappearing search log
- Fixed crash during diff view text layout

#### Version 2.5.6 (6795) - Mar 22 2022 

- Attempt to fix crash caused by `libswift_Concurrency` when restoring MAS purchases

#### Version 2.5.5 (6792) - Mar 18 2022 

- Updated git service symbols
- Fix wrong git instance used when 2 app versions are on the system
- Fix delayed commit message editor text layout
- Fix image diff not displaying the asset

#### Version 2.5.4 (6729) - Mar 08 2022 

- Add the `workflow` scope when authenticating with Github
    - ⚠️ You will have to remove and re-authorize your Github account for the `workflow` scope to take effect.

#### Version 2.5.3 (6705) - Feb 23 2022 

- Graph lanes are no longer clipped if log width too small
- Fix progress display when cloning submodule
- Fix progress display on remote add (fetch)

#### Version 2.5.2 (6692) - Feb 21 2022 

- **New**: `Git` preference pane
    - Choose any `git` instance in your `PATH`
    - Update your global `git` user name and email
- **New**: Updated `git` to `2.35.1`
- Clear file selection on discard
- Include repository link in automatic links
- The 3-finger swipe between views is now dependent on the `Swipe between pages` system setting
    - This was done to prevent a conflict with the 3-finger drag accessibility option
- Fixed auto-populate of repository links
- Fixed repo names that contain periods
- Fixed label flicker in log when scrolling

#### Version 2.4.0 (6656) - Feb 04 2022 

- **New**: Compare any local, remote or tag ref to any other
    - New "Compare X To" context menu on reference items in the outline
- **New**: Sort local, remote and tag refs
    - New context menu on local, remote and tag sections
    - Sort methods:
        - Alphabetically
        - By Version
        - By Creator Date (Last Committed)
    - Sort options:
        - Reverse Order
        - Keep Folders on Top
        - Keep Default Branch on Top
- **New**: Option to copy refnames/shorthands from reference outline items
- **New**: "Push X" context menu item for individual tags
- Pre-fill branch name in copy/move dialogs
- Clear repo manager outline selection after delete
- Don't show repo delete alert for already deleted repositories
- Fixed tag delete if no remote present

#### Version 2.3.4 (6632) - Jan 20 2022 

- Fixed an issue that caused the changes view to immediately pop again

#### Version 2.3.3 (6629) - Jan 20 2022 

- Both, the commit and author date, are now shown in the `Date` row
- Minimum window width was reduced to 980px for better vertical display support
- Shortcuts are now shown in button tooltips
- Fixed: Properly update the log after a stash was pushed or popped
- Fixed: Crash when closing search predicate editor

#### Version 2.3.1 (6619) - Jan 11 2022 

- Fixed: Issue where autofetch would not work correctly

#### Version 2.3.0 (6617) - Jan 06 2022 

- **New**: Format and export mailbox patches for selected commits
- **New**: Apply mailbox patches with `Repository > Apply Patch...`
- **New**: `Meld` diff and mergetool preset
- Fixed: Error when trying to perform a directory diff
- Fixed: CSS dark mode image background color
- Fixed: Crash when trying to undo actions recorded in a different view
- Fixed: Crash when updating progress display
- Fixed: Crash when showing status popover and navigating views at the same time

#### Version 2.2.1 (6607) - Jan 03 2022 

- Fixed: Crash from exception caused by subprocess interrupt

#### Version 2.2.0 (6602) - Jan 02 2022 

- **New**: `Visual Studio Code` diff and mergetool preset
- **New**: You can now filter the shortcuts list
- **New**: You can now drag and drop files from the status list to other apps or the dock
- **New**: The `Open With...` file context menu now also works if multiple files are selected
- **New**: Force push shortcuts and quick actions
    - Force Push with Lease... `OPT+CMD+U`
    - Force Push...  `CTRL+OPT+CMD+U`
- The shortcut system has been enhanced to support nested menu items
    - ⚠️ Due to the fundamental changes in the shortcut system you will have to rebind any custom shortcuts.
- The "Open/Show In" shortcuts have been split into explicit actions for your current selection or the whole repository:
    - Show Repository in Terminal `SHIFT+CMD+T`
    - Show Selection in Terminal `OPT+SHIFT+CMD+T`
    - Show Repository in Finder `SHIFT+CMD+F`
    - Show Selection in Finder `OPT+SHIFT+CMD+F`
    - Open Repository in Editor `SHIFT+CMD+E`
    - Open Selection in Editor `OPT+SHIFT+CMD+E`
- Many shortcut have been changed to shorter key combinations
    - Fetch: `CMD+SHIFT+F` to `F`
    - Fetch All Remotes: `None` to `OPT+F`
    - Pull: `CMD+SHIFT+P` to `P`
    - Pull HEAD: `CMD+SHIFT+OPT+P` to `OPT+P`
    - Push: `CMD+SHIFT+U`to `U`
    - Push HEAD: `CMD+SHIFT+OPT+U` to `OPT+U`
    - Create New Branch: `CMD+B` to `B`
    - Create New Tag: `CMD+SHIFT+T` to `T`
    - Open Diff or Mergetool: `CMD+D` to `D`
    - Toggle Stage All: `CMD+Shift+Space` to `OPT+Space`
    - Push Stash: `CMD+SHIFT+S` to `S`
    - Apply Stash: `CMD+OPT+SHIFT+S` to `OPT+S`
    - Rebase: `CMD+SHIFT+R` to `R`
    - Merge into HEAD: `CMD+SHIFT+M` to `M`
- The shell environment is now only evaluated once on startup to speed things up
- The error dialog now shows the combined output from STDOUT and STDERR
- Fixed: The "Show" button in the repository manager now correctly shows the repository again
- Fixed: Crash when external process produced a `SIGPIPE`
- Fixed: Race condition when loading large diffs
- Fixed: Overlapping text blocks in split diff view when certain unicode characters where used
- Fixed: Plural/singular in commit changes footer

#### Version 2.1.0 (6488) - Nov 20 2021 

- **New**: Commit Message Links
    - The link manager now has a new `Commit Message Links` section where you can specify custom regular expressions that are transformed into clickable links, e.g. for issue labels of external issue trackers.
    - HTTP URLs and issue references for services like GitHub, GitLab and Bitbucket are made clickable by default.
- The link manager shortcut was changed to `L`
- Text selection for commit header values is back
- The committer gravatar now only shows when the committer differs from the author
- Fixed an issue with truncated commit message text (ellipsis)
- Fixed an issue with clipped commit header labels
- Fixed empty `Parents` row for root commits
- Fixed empty log if git is misconfigured with an empty email address
- Fixed crash in conflicting shortcut popover
- Fixed GitHub and GitLab label casing

#### Version 2.0.7 (6455) - Nov 10 2021 

- Fix missing log entries if git author was misconfigured

#### Version 2.0.6 (6451) - Nov 08 2021 

- Fix stash push with empty message

#### Version 2.0.5 (6448) - Nov 07 2021 

- Fix crash when opening remote edit panel from "authentication failed" alert

#### Version 2.0.4 (6444) - Nov 06 2021 

- Ensure push stash `--all` and `--include-untracked` are mutually exclusive
- Fix memory leak in search predicate editor and file outline
- Fix crash that could occur when showing dialog panels

#### Version 2.0.3 (6431) - Nov 01 2021 

- Delete selected tags and branches using `CMD+DEL`
- Installing the CLI tool now asks for authorization to prevent permission errors
- Explicitly set `--no-track` option when creating a new branch from another to avoid implicit `branch.autoSetupMerge` behavior
- Restored branch name sanitizing replacing whitespace with `-` for branch and tag name inputs
- Fixed: Crash when displaying error panel while changing views

#### Build 6415 - Oct 26 2021 

- Correctly update the log when finishing git-flow branches
- More gravatar fallback colors
- Fix no files being displayed in merge commits
- Fix performance hiccup when switching between tree/changeset

#### Build 6401 - Oct 20 2021 

- Fixed: Crash in apply stash panel

#### Build 6397 - Oct 19 2021 

Welcome to Gitfox 2.0! 🎉

- The app has undergone a major rewrite and redesign to better fit macOS 11
- Commit and amend from anywhere with the new commit editor panel
- New text diff view
- New image diff view with split option
- File tree is now available
- Blame is now available
- New search predicate editor
- New grouped file view
- You can now compare any 2 commits
- The UI is now completely navigable by keyboard
- Diff font is now customizable
- Updated git to v2.33.0
- Any much more...
