- Only highlight git comments if the `#` sign is at the line start
- Fixed commit editor not correctly handing diacritic characters
    - For example, conversion of `~ + a` to `ã`
- Fixed branches not being shown if `creatordate` used the Zulu date format

#### Version 3.9.4 (9613) - Jul 5 2024

- Fixed crash when popping repository view

#### Version 3.9.3 (9610) - Jul 3 2024

- General UI performance improvements
- Fixed long branch names causing overly wide push dialog
- Fixed memory leak 

#### Version 3.9.2 (9584) - Jun 28 2024

- General UI performance improvements
- Fixed hang when showing a huge amount of files
    - The alert before showing the files was removed, as it is no longer necessary 
- Fixed file path display when toggling the view mode from grouped to list 
- Fixed hang when showing modal open panel
- Fixed hang when installing or deinstalling the CLI tool

#### Version 3.9.1 (9523) - Jun 22 2024

- New crash report dialog
- Mergetools now open with the `mergetool.writeToTemp` flag as to not pollute the repository with backup files
- Updated `cmark-gfm` markdown renderer to `0.29.0.gfm.13`
- Fixed mergetool creating backup files for `DELETED` files
    - Mergetools cannot open for `DELETED` files, so the difftool is opened instead if possible
- Fixed mergetool not properly opening for all status entries
- Fixed space appearing between toolbar and repository manager on first launch
- Fixed initial repository manager pane widths on first launch 

#### Version 3.9.0 (9402) - May 6 2024

- New: Recent messages button in commit view
    - Added a button to restore your 15 most recent commit messages, starting from `HEAD`
- New: Split `Open Diff or Mergetool` into 2 distinct commands. To make actions
    unambiguous, there are now 2 separate commands for the commit and file level.
    If you prefer one over the other, you can always change your preferred
    shortcuts in the preferences.
    - `Open Diff or Mergetool` always opens the diff for all files in the current commit or `HEAD`
    - `Open Diff or Mergetool for Selection` always opens the diff for selected files only
- Improved performance when parsing `git` dates
- Progress indicator now shows an arrow on hover, indicating it is clickable

#### Version 3.8.11 (9312) - Apr 4 2024

- Fixed new branch/tag actions beeping instead of popping up dialog when no branch was selected
- Fixed file context menu not showing when CTRL-clicking on text
- Fixed high CPU usage when typing in new branch text field
- Fixed issue preventing authentication panel from showing on connection error

#### Version 3.8.10 (9233) - Mar 18 2024

- New: GitLab subgroups are now being shown in the repository manager
- The commit message field is now pre-populated with `SQUASH_MSG` if it exists
- Fixed minor user interface issues

#### Version 3.8.9 (9168) - Feb 24 2024

- Fixed an issue where the app would hang when running for a long time

#### Version 3.8.8 (9165) - Feb 22 2024

- Fixed an issue causing heavy CPU utilization when expanding tree nodes 

#### Version 3.8.7 (9156) - Feb 16 2024

- Generated `README` and `.gitignore` files are now committed directly
    - Previously the user had to commit those files themselves after repository creation
- Fixed an issue where status entries weren't shown when the `status.showStash` flag was set to `true`
- Fixed an issue that resulted in an error when enabling the git-flow `Fetch Origin` option 
- Fixed an issue that prevented remotes not being shown when branches weren't fetched yet

#### Version 3.8.6 (9147) - Feb 12 2024

- Fixed issue causing automatic fetch timer to not trigger
- Fixed crash when trying to present multiple error panels

#### Version 3.8.5 (9140) - Feb 6 2024

- Don't show error dialog if process exited with an abnormal exit code, but did not produce a message on `STDERR` or `STDOUT`
- Minor fixes and performance improvements
- Fixed root commit not producing diff

#### Version 3.8.4 (9034) - Jan 31 2024

- Fixed repository outline selection reverting to `Worktree` when popping the changes view
- Fixed crash that could happen when using accessibility tools

#### Version 3.8.3 (9030) - Jan 29 2024

- Fixed diff view not updating sometimes when discarding a line

#### Version 3.8.2 (9027) - Jan 26 2024

- Ensure the default shell environment is loaded as early as possible
- Performance improvements when showing 10k+ status items
- Ask for confirmation before showing more than 1000 files at once to prevent hangs
- Fixed diff view not properly updating on macOS 14.3 
- Fixed checkmarks not being cleared after toggling "Display Merged Branches"
- Fixed the `MOVE` drag label disappearing when moving outside the log area
- Fixed crash when reloading the file outline

#### Version 3.8.1 (8871) - Jan 4 2024

- New: Bisect preview dialog
    - A "Bisect..." menu item was added alongside a configurable shortcut
- Updated `git` to `2.43.0`
- Updated `scc` to `3.2.0`
    - This fixes code statistics not loading for some repositories 
- Most dialogs and settings have been rewritten in SwiftUI
- Fixed an issue where the current instead of the selected git-flow branch was used
- Fixed an issue where custom git-flow prefixes were not being used
- Fixed an issue where fast-forwarding a branch would not work sometimes
- Fixed log not reloading when aborting bisect

#### Version 3.8.0 (8734) - Dec 17 2023

- New: New commit search bar
    - The complex predicate editor was replaced by a simple search bar
    - Partial dates parsed from the search query are relative to the current date
    - Search progress is now displayed in the toolbar
- New: Improved notification style
    - Notification text now should be easier to parse visually
- Fetching the HEAD or all remotes (including automatic fetch) now respects the "Fetch All Tags" setting
- Automatic fetch now fetches all remotes, not just the HEAD remote.
- Renamed toolbar "Save Stash..." action to "Push Stash..." to match dialog title
- Fixed applying wrong stash when opening "Apply Stash" dialog from toolbar

#### Version 3.7.4 (8674) - Nov 11 2023

- New: "Discard Behavior" in "General" preference pane
    - Choose if you want stash or discard to be the default
- Updated account picker with service sections
- The "Delete on Remote" setting is no longer persistent
- Raised macOS deployment target to 13.5
- Fixed commit editor column marker position being displayed in the wrong position 

#### Version 3.7.3 (8636) - Oct 17 2023

- Image Diff:
    - Images are now labeled with their corresponding version (`A` or `B`)
    - Image sizes are now given in `points` if there is no corresponding `pixel` value
- Hitting `B` while a branch is selected in the repository outline will now use that branch as starting point
- Fixed issue on macOS 14 refreshing GitLab account tokens
- Fixed issue on macOS 14 causing context menu actions picking wrong items

#### Version 3.7.2 (8590) - Oct 14 2023

- The toolbar progress indicator now has an indeterminate mode
- The "New Tag" view now uses the commit editor for the message
- The "Delete Tag" view now shows a branch list instead of a popup button
- The "Delete Branches" view now shows a branch list instead of a popup button
- Fixed issue that clipped log branch labels
- Fixed Non-HEAD branches showing status header
- Fixed line breaks in "New Branch" dialog name field
- Fixed missing dialog icon badges

#### Version 3.7.1 (8514) - Sep 13 2023

- Ready for macOS 14.0 Sonoma
- Show alert on crash if macOS version is outdated

#### Version 3.7.0 (8475) - Aug 28 2023

- New: Commit View Options
    - New "Reset Author" option
    - The "Sing Off" option is now saved on a repository basis
    - The commit button now shows all selected flags
- New: Config Syntax Highlighting
    - Syntax highlighting of git configuration files has been expanded to sections, strings and booleans.
    - Reveal config file in finder by clicking the path

#### Version 3.6.3 (8441) - Aug 16 2023

- New: Bisect
    - New bisect session view
    - Start bisect sessions from the log context menu
- The context toolbar now shows a "more" indicator if some buttons are hidden
- The `init.defaultBranch` value is now used as the default git-flow production branch, if present
- Comparison cells now show A/B instead of the commit hashes 
- Updated bundled git version to 2.41.0
- Raised macOS deployment target to 13.0
- Fixed some actions only working when file outline was focussed
- Fixed an issue that caused commit range diffs to be displayed in the wrong order
- Fixed an issue that caused files to be unstaged instead of staged and vice versa when clicking the "Un/stage All" button

#### Version 3.6.2 (8381) - Aug 2 2023

- Fixed crashes on macOS 12 Monterey

#### Version 3.6.1 (8374) - Aug 1 2023

- File path (group) nodes are now also selectable by keyboard
- Fixed commit panel showing on `C` when no staged changes are present
- Fixed crashes on macOS 12 Monterey

#### Version 3.6.0 (8358) - Jul 30 2023

- New: The file outline can now be filtered
    - Filter by text and status (added, deleted, modified, untracked)
    - Path groups can now be collapsed
- The view mode select was moved to the new filter bar
- Fixed issue where commit message was not cleared on commit+push, when the push failed
- Fixed additional hanging issues in macOS 14 beta
- Many under the hood improvements

#### Version 3.5.1 (8102) - Jul 8 2023

- Implemented a temporary workaround for hanging issues in macOS 14 beta
- Prevent automatic download for expired OTP licenses
- Fixed display issue when diff produced more than one patch
- Fixed issue not using correct author when committing with different identity

#### Version 3.5.0 (8092) - Apr 13 2023

- New: GitHub authentication via Personal Access Token
- Updated the GitHub OAuth organization alert text to match current GitHub settings
- Fixed submodules not working correctly if the name contained a space

#### Version 3.4.5 (8076) - Apr 2 2023

- Software update dialog now shows more information (retail only)
- Prevent update checks for expired OTP versions (retail only) 

#### Version 3.4.4 (8061) - Mar 20 2023

- Fix crash when restoring windows of deleted repositories

#### Version 3.4.3 (8058) - Mar 16 2023

- Fix changed files not showing up in empty repository

#### Version 3.4.2 (8053) - Mar 8 2023

- Fixed issue preventing automatic fetch
- Fixed error when trying to discard `RENAMED` and `DELETED` files via stash
- Fixed error when trying to drop all stashes at once

#### Version 3.4.1 (8030) - Feb 22 2023

- Fixed issue causing log to not be completely displayed when less than 50 entries

#### Version 3.4.0 (8020) - Feb 20 2023

- New: `Discard` / `Discard All` now stages the files by default instead of deleting
    - The option to delete is still there, but marked as a destructive action.
- New: Update submodule now supports the `--remote` flag
- New: Add submodule now has a path selector
- Fixed issue creating new private Bitbucket repos as public
- Fixed issue preventing clone with certain `askpass` prompt format
- Many other smaller fixes and improvements

#### Version 3.3.0 (7799) - Dec 22 2022

- New: Merge preflight check
    - Shows the number of conflicts in the merge panel before performing the merge
- New: Add new merge panel options
    - `No Automatic Commit`
    - `Skip Hooks`
- Fix issue reading diff containing binary data fragments
- Fix issue with window title not showing custom display name

#### Version 3.2.1 (7764) - Dec 11 2022

- New: `Only Stash Staged Changes` option when pushing a stash
    - This is equal to `git stash push --staged` 
- Color hashes for avatars now produce more pleasing and consistent colors
- Fix repositories in folders not showing up as "Open" quick actions

#### Version 3.2.0 (7742) - Dec 2 2022

- New: Add and manage linked worktrees
    - New `Repository > Add Worktree... (W)` action
    - New `Remove` and `Open` linked worktree context menu items
    - Linked worktrees are now shown as children of the main worktree
    - Navigate to the linked worktree by double-clicking it in the outline
- New: Choose how to open linked worktrees and submodules
    - New `View > Submodules & Worktrees >` menu item
        - Option `Push in Same Window`
        - Option `Open in New Tab`
        - Option `Open in New Window`

#### Version 3.1.0 (7671) - Nov 22 2022

- New: The commit header view now has a compact format
    - You can toggle this via `View > Compact Commit Header`
- New: Commit header values can be copied in different formats
    - Identities: Email, name and mailbox
    - Dates: Unix and ISO 8601 timestamps
    - Hashes: The full hash
- Fix log update on stash save & apply
- Fix an issue preventing opening of repositories created with `git-worktree`
- Fix misaligned commit message text and label

#### Version 3.0.6 (7635) - Nov 14 2022

- The repository outline view now reacts properly to the "Sidebar icon size" system setting
- Use correct unstage symbol for "Unstage All" button 
- Replace all remaining icons with SF symbols throughout the app
- Fix issue where "Commit & Push" would not push afterwards
- Fix misaligned blame disclosure triangle
- Fix misaligned repository outline view disclosure indicators

#### Version 3.0.5 (7583) - Nov 9 2022

- Refresh service account after creating new repository on it
- Fix text views not properly scrolling while typing on macOS Ventura
- Fix micro hang when sorting refnames
- Fix deadlock when refreshing service accounts

#### Version 3.0.4 (7526) - Nov 2 2022

- Fix long refresh time in repository manager
    - Sometimes the repository status would not update for a few seconds
- Fix small delay at startup loading shell path

#### Version 3.0.3 (7516) - Nov 1 2022

- Keyboard navigation in the repository manager is back
- Accounts are loaded in the background to reduce app launch time
- Fixed some connection errors for GitHub accounts

#### Version 3.0.2 (7497) - Oct 31 2022

- Improved speed when restoring repository windows
- Disable context menu in README views
- Fixed connection errors for certain GitHub accounts

#### Version 3.0.0 (7473) - Oct 27 2022

Welcome to Gitfox 3.0 🎉

- New: Brand-new repository manager layout
- New: Code and commit statistics
- New: Remote service account repositories are directly shown in the repository manager
- New: Clone remote repositories with a single click
- New: When creating a new local repository, you can now choose to create it on a service account as well
- New: Show the README file for remote service account repositories
- New: Filter all repositories, including remote repositories
- Raised macOS deployment target to 12.4
